/************************************************************************************************
 *   ������Ħ�����������޹�˾ @�汾����@
 *
 *   ���ļ����ڽ��տ���������
 *
 * �޸�:
 *   1. ���� : ����
 *      ���� : ������
 *      ʱ�� : 2010.04.04
 *      ���� : ���д���
 *************************************************************************************************/
/* exported  mc_sdk_req_mgr */
/* exported  mc_sdk_apply_box */
/* exported  mc_sdk_hardware_data */
/* exported  mc_sdk_updata_box_param */
/* global $ */
/* global mc_sdk_param */
/* global ARY_MOD_DATA */
/* global ARY_BOX_DATA */

/************************************************************************************************
 * ����:
 *    ����
 * ����:
 *    SDK�����������ͨ���������Ӧ��Ϊ����
 * ����:
 *    NA
 * ���أ�
 *    NA
 * �޸�:
 *   1. ���� : ����
 *      ���� : ������
 *      ʱ�� : 2020.4.4
 *      ���� : ���д���
 ************************************************************************************************/
function mc_sdk_req_mgr() {
    var ui_fifo_max_size = 1024;
    var b_req_busy = false;
    var ui_head_idx = 0;
    var ui_tail_idx = 0;
    var ary_sdk_req_fifo = [];

    /* request data struct */
    function req_obj() {
        this.str_req_json = "";
        this.fn_callback = null;
    }

    /* request operater */
    function post_req() {
        if (b_req_busy) {
            return;
        }

        if (ui_head_idx === ui_tail_idx) {
            return;
        }

        b_req_busy = true;

        var obj_req = ary_sdk_req_fifo[ui_head_idx];

        /* next request */
        ui_head_idx++;
        if (ui_head_idx >= ui_fifo_max_size) {
            ui_head_idx -= ui_fifo_max_size;
        }

        /* deal request */
        $.post("/access_shell", obj_req.str_req_json, function (response, status) {
            if (obj_req.fn_callback instanceof Function) {
                obj_req.fn_callback(response, status);
            }

            b_req_busy = false;
            post_req();
        });
    }

    /************************************************************************************************
* ����:
*    ����
* ����:
*    ��SDK�����첽��������һ������
* ����:
*    @param {Promise<string>} str_req_json �����JSON�ִ�������Ϊ��
*    @param {Promise<Function>} fn_callback ����Ļص�����������ԭ�ͣ�function callback(str_rsp_json, str_status), ��$.post�ص�ǰ������������һ��
* ���أ�
*    @returns {Promise<Number>} 0:�ɹ���1:�����������2:������������ʱ���в����մ�����
* �޸�:
*   1. ���� : ����
*      ���� : ������
*      ʱ�� : 2020.4.4
*      ���� : ���д���
************************************************************************************************/
    this.push_req = function (str_req_json, fn_callback) {
        if ("string" !== typeof str_req_json || 0 === str_req_json.length) {
            return 1;
        }

        if (fn_callback && !(fn_callback instanceof Function)) {
            return 1;
        }

        /* test full status */
        var ui_tail_idx_tmp = ui_tail_idx;

        if (ui_tail_idx_tmp < ui_head_idx) {
            ui_tail_idx_tmp += ui_fifo_max_size;
        }
        if (ui_tail_idx_tmp + 1 - ui_head_idx >= ui_fifo_max_size) {
            return 2;
        }

        /* add request */
        ary_sdk_req_fifo[ui_tail_idx] = new req_obj();
        ary_sdk_req_fifo[ui_tail_idx].str_req_json = str_req_json;
        ary_sdk_req_fifo[ui_tail_idx].fn_callback = fn_callback;

        /* update status */
        ui_tail_idx++;
        if (ui_tail_idx >= ui_fifo_max_size) {
            ui_tail_idx -= ui_fifo_max_size;
        }

        /* trigger exec */
        post_req();

        return 0;
    };
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    应用当前箱体数据
 * 参数:
 *    @param {Promise<string>} box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 箱体链接数据
 *    @param {Promise<Array>} ary_mod_data 模组数据
 *    @param {Promise<Function>} fn_callback 回调函数
 *    @param {Promise<Number>} ui_sdk_type 下发模式
 * 返回：
 *    NA
 * 备注:
 *     0:参数错误
 *     1:芯片错误
 *     2:分组模式错误
 *     3:引脚错误
 *     4:三线并行颜色错误
 *     5:未知错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_sdk_apply_box(box_name, ary_box_data, ary_mod_data, fn_callback, ui_sdk_type) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof box_name || 0 >= box_name.length) {
        fn_callback(0);
        return;
    }
    if (!Array.isArray(ary_box_data) || 0 >= ary_box_data.length) {
        fn_callback(0);
        return;
    }
    if (!Array.isArray(ary_mod_data) || 0 >= ary_mod_data.length) {
        fn_callback(0);
        return;
    }
    var idx_box = mc_data_get_idx_in_name(ary_box_data, box_name);

    if (!idx_box && 0 !== idx_box) {
        fn_callback(0);
        return;
    }
    var obj_box_data = ary_box_data[idx_box].data;

    var obj_box_msg = obj_box_data.mc_util_get_ui_box_msg();
    var str_first_mod_name = obj_box_data.mc_util_get_box_first_mod_name();
    var obj_recvcard_data = null;

    if ("function" === typeof mc_main_get_box_xml) {
        obj_recvcard_data = mc_main_get_box_xml(obj_box_msg, str_first_mod_name, ary_mod_data);
    } else {
        obj_recvcard_data = parent.mc_main_get_box_xml(obj_box_msg, str_first_mod_name, ary_mod_data);
    }

    if ("object" !== typeof obj_recvcard_data) {
        fn_callback(obj_recvcard_data);
        return;
    }
    var ctrlchip_name = obj_box_msg.ctrlchip_name;
    var box_data = obj_recvcard_data.mc_util_recvcard_get_xml();
    var param_ui_json = obj_box_data.mc_util_get_param().get_json();
    var dischip_reg = obj_box_data.mc_util_get_disp_reg().get_json();
    var scanchip_reg = obj_box_data.mc_util_get_scan_reg().get_json();
    var dischip_list = obj_box_data.mc_util_get_disp_reg_list().get_json();
    var scanchip_list = obj_box_data.mc_util_get_scan_reg_list().get_json();

    var ui_first_mod_idx = mc_data_get_idx_in_name(ary_mod_data, str_first_mod_name);
    var obj_sdk_module = ary_mod_data[ui_first_mod_idx].data;
    var dispchip_name = obj_sdk_module.mc_util_mod_get_disp_chip();
    var scanchip_name = obj_sdk_module.mc_util_mod_get_scan_chip();

    var ary_box_mod_list = [];
    var ui_mod_list_cnt = obj_recvcard_data.mc_util_recvcard_get_modlist_cnt();

    for (var idx_led_list = 0; idx_led_list < ui_mod_list_cnt; idx_led_list++) {
        var ui_led_mod_cnt = obj_recvcard_data.mc_util_recvcard_get_modlist_mod_cnt(idx_led_list);

        for (var idx_led_mod = 0; idx_led_mod < ui_led_mod_cnt; idx_led_mod++) {
            var str_mod_name = obj_recvcard_data.mc_util_recvcard_get_modlist_mod_name(idx_led_list, idx_led_mod);
            var ui_mod_idx = mc_data_get_idx_in_name(ary_mod_data, str_mod_name);
            var str_mod_xml = ary_mod_data[ui_mod_idx].data.mc_util_mod_get_xml();
            var b_mod_is_exist = false;

            // 查找模组是否重复
            for (var idx_mod_list = 0; idx_mod_list < ary_box_mod_list.length; idx_mod_list++) {
                var str_mod_name_exist = ary_box_mod_list[idx_mod_list].name;

                if (str_mod_name_exist === str_mod_name) {
                    b_mod_is_exist = true;
                    break;
                }
            }
            if (b_mod_is_exist) {
                continue;
            }
            ary_box_mod_list.push({
                name: str_mod_name,
                data: str_mod_xml
            });
        }
    }
    /* reset_sdk */
    if (1 === ui_sdk_type) {
        set_dispchip_reg();
    } else if (2 === ui_sdk_type) {
        set_param();
    } else {
        set_box();
    }
    /* set_box */
    function set_box() {
        mc_sdk_set_box(box_name, box_data, set_mod);
    }

    /* set_mod */
    function set_mod() {
        mc_sdk_set_mod(ary_box_mod_list, set_param);
    }

    /* set_param */
    function set_param() {
        mc_sdk_set_param(param_ui_json, set_dispchip_reg);
    }

    /* set_dispchip_reg */
    function set_dispchip_reg() {
        mc_sdk_set_reg(ctrlchip_name, dispchip_name, true, dischip_reg, set_scanchip_reg);
    }

    /* set_scanchip_reg */
    function set_scanchip_reg() {
        mc_sdk_set_reg(ctrlchip_name, scanchip_name, false, scanchip_reg, set_dispchip_reg_list);
    }

    /* set_dispchip_reg_list */
    function set_dispchip_reg_list() {
        mc_sdk_set_reg_list(ctrlchip_name, dispchip_name, true, dischip_list, set_scanchip_reg_list);
    }

    function set_scanchip_reg_list() {
        mc_sdk_set_reg_list(ctrlchip_name, scanchip_name, false, scanchip_list, set_success_callback);
    }
    function set_success_callback() {
        // 临时处理 是否存入模组信息 防止初次加载文件 未存入模组信息导致部分界面无法获取报错
        // if (!parent.G_OBJ_MOD_MSG) {
        // if (!parent.SELECT_MOD_NAME || 0 === ARY_MOD_DATA.length || 0 === ARY_BOX_DATA.length) {
        //     fn_callback(true);
        //     return;
        // }
        try {
            parent.G_OBJ_MOD_MSG = mc_set_mod_param(parent.SELECT_MOD_NAME, ary_mod_data, box_name, ary_box_data);
        } catch (error) {
            parent.G_OBJ_MOD_MSG = new mc_sdk_param();
        }
        // }

        fn_callback(true);
    }
}

// 临时处理 是否存入模组信息 防止初次加载文件 未存入模组信息导致部分界面无法获取报错
function mc_set_mod_param(mod_select, ary_mod, box_select, ary_box) {
    // var obj_return =new mc_sdk_param()
    var ui_len_mod = ary_mod.length;
    var ui_len_box = ary_box.length;

    var obj_mod = "";
    var obj_box = "";

    for (var id = 0; id < ui_len_mod; id++) {
        var mod_each = ary_mod[id].name;

        if (mod_each === mod_select) {
            obj_mod = ary_mod[id].data;
        }
    }
    for (var key = 0; key < ui_len_box; key++) {
        var box_each = ary_box[key].name;

        if (box_each === box_select) {
            obj_box = ary_box[key].data.mc_util_get_ui_box_msg();
        }
    }

    if (!obj_mod || !obj_box) {
        return null;
    }

    // 需存储的数据
    var obj_param = {
        // 显示芯片
        "MC_LANG_DISPCHIP_LIST": obj_mod.mc_util_mod_get_disp_chip(),
        // 行管芯片
        "MC_LANG_SCANCHIP_LIST": obj_mod.mc_util_mod_get_scan_chip(),
        // 宽
        "MC_LANG_LABLE_WEITH": obj_mod.mc_util_mod_get_width() + "",
        // 高
        "MC_LANG_LABLE_HEIGHT": obj_mod.mc_util_mod_get_height() + "",
        // // 放电低有效
        "MC_LANG_LABLE_CLOSE_LOW_VALID": obj_mod.mc_util_mod_get_close_low_valid() + "",
        // // 行扫数
        "MC_LANG_LABLE_SCAN_CNT": obj_mod.mc_util_mod_get_max_scan_cnt() + "",
        // // 测试行
        "MC_LANG_LABLE_TEST_SCAN": "1",
        // // 主控芯片
        "MC_LANG_CTRLCHIP_LIST": obj_box.ctrlchip_name,
        // // 主控hub
        "MC_LANG_LABLE_HUB": obj_box.hub_name,
        // oe
        "MC_LANG_LABLE_OE_LOW_VALID": obj_mod.mc_util_mod_get_oe_low_valid() + "",
        // tx
        "MC_LANG_LABLE_TX_LOW_VALID": obj_mod.mc_util_mod_get_tx_low_valid() + ""

    };

    // 动态添加 时钟 颜色 串行类型数量
    var ui_sclk_cnt = obj_mod.mc_util_mod_get_sclk_pin_cnt();
    // 时钟

    if (1 < ui_sclk_cnt) {
        var str_sclk_key = "";
        var idx;

        for (idx = 1; idx < ui_sclk_cnt; idx++) {
            str_sclk_key = "MC_LANG_LABLE_SCLK_" + (idx + 1);
            var str_val = obj_mod.mc_util_mod_get_sclk_pin_name(idx);

            obj_param[str_sclk_key] = str_val;
        }
        obj_param["MC_LANG_LABLE_SCLK_" + (idx + 1)] = "MC_LANG_OPTION_NOT_USE";
    } else {
        obj_param.MC_LANG_LABLE_SCLK_2 = "MC_LANG_OPTION_NOT_USE";
    }

    // 颜色
    var arr_clr = obj_mod.mc_util_mod_get_clr_msg();

    for (var clr_idx = 0; clr_idx < arr_clr.length; clr_idx++) {
        var str_each_clr = arr_clr[clr_idx];

        switch (str_each_clr) {
            case "R":
                str_each_clr = "1";
                break;
            case "G":
                str_each_clr = "2";
                break;
            case "B":
                str_each_clr = "3";
                break;
            case "V":
                str_each_clr = "4";
                break;

            default:
                str_each_clr = "1";
                break;
        }
        var str_clr_key = "MC_LANG_LABLE_COLOR_" + (clr_idx + 1);

        obj_param[str_clr_key] = str_each_clr;
    }

    // 数据线数量
    var str_cnt = obj_mod.mc_util_mod_get_str_cnt();

    // // 数据组类型
    var grp_type = obj_mod.mc_util_mod_get_str_grp_mode();

    obj_param.MC_LANG_LABLE_TXGRP_MODE = grp_type + "";
    if (1 === Number(grp_type)) {
        // 串行类型
        obj_param.MC_LANG_LABLE_LED_GRP_MODE = obj_mod.mc_util_mod_get_led_type() + "";
        // 数据组数
        obj_param.MC_LANG_LABLE_TXGRP_CNT = str_cnt + "";
    } else {
        obj_param.MC_LANG_LABLE_TXGRP_CNT = (str_cnt / grp_type) + "";
    }


    // console.log(obj_param);

    // // 临时比较
    // var obj_temp = parent.G_OBJ_MOD_MSG;
    // var cnt = obj_temp.get_param_cnt();

    // var b_jungle = true;

    // for (var j = 0; j < cnt; j++) {
    //     var each_name = obj_temp.get_param_name(j);
    //     var each_val = obj_temp.get_param_value(each_name);

    //     if (!obj_param[each_name]) {
    //         b_jungle = [0, each_name, each_val];
    //         break;
    //     }

    //     if (obj_param[each_name] !== each_val) {
    //         b_jungle = [1, each_name, each_val];
    //         break;
    //     }
    // }

    var obj_new = new mc_sdk_param();


    for (var k in obj_param) {
        if (Object.hasOwnProperty.call(obj_param, k)) {
            var val = obj_param[k];

            obj_new.set_param_value(k, val);
        }
    }

    // console.log(b_jungle);
    // console.log(JSON.parse(obj_new.get_json()));
    return obj_new;
}


/* exported mc_sdk_reset */
/* exported mc_sdk_set_box */
/* exported mc_sdk_set_box_list */
/* exported mc_sdk_set_mod */
/* exported mc_sdk_set_param */
/* exported mc_sdk_set_reg */
/* exported mc_sdk_set_reg_list */
/* exported mc_sdk_send_box_base */
/* exported mc_sdk_get_box_base */
/* exported mc_sdk_get_param */
/* exported mc_sdk_get_dispchip_normal */
/* exported mc_sdk_get_dicpchip_info_msg */
/* exported mc_sdk_get_dispchip_access */
/* exported mc_sdk_get_reg */
/* exported mc_sdk_get_reg_list */
/* exported mc_sdk_get_hw_msg */
/* exported mc_sdk_send_box_presave */
/* exported mc_sdk_send_box_perstore */
/* exported mc_sdk_hw_hubcard_reg */
/* exported mc_sdk_hw_hubcard_save */
/* exported  mc_sdk_send_memory_box_base */
/* exported  mc_sdk_hw_get_revcard */
/* exported  mc_sdk_get_vers_number */
/* exported  mc_sdk_get_ctrlchip_list */
/* exported  mc_sdk_get_hubchip_list */
/* exported  mc_sdk_get_recvcard_hub_file */
/* exported  mc_sdk_get_dispchip_list */
/* exported  mc_sdk_get_scanchip_list */
/* exported  mc_sdk_set_box_tplparam */
/* exported  mc_sdk_get_box_tplparam_list */
/* exported  mc_sdk_get_box_tplparam */
/* exported  mc_sdk_hw_red_write */
/* exported  mc_sdk_hw_box_gama */
/* exported  mc_sdk_hw_box_gamut */
/* exported  mc_send_box_bright_date */

/**
* reset_sdk
* @param {Promiise<string>} ary_reset_list 重置列表
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_reset(ary_reset_list, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_func("RESET");
    obj_sdk_param.set_cmd("SET_PARAM");
    if (Array.isArray(ary_reset_list)) {
        for (var idx_rest = 0; idx_rest < ary_reset_list.length; idx_rest++) {
            var obj_reset_val = ary_reset_list[idx_rest];
            var str_reset_type = obj_reset_val.reset_type;
            var str_ctrlchip = obj_reset_val.ctrlchip_name;

            if (str_reset_type) {
                obj_sdk_param.set_param_value(obj_reset_val.reset_type, "");
                if (str_ctrlchip) {
                    obj_sdk_param.set_attr_val(str_reset_type, "CTRLCHIP", str_ctrlchip);
                }
            }
        }
    }

    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

/**
* set_box_from_sdk
* @param {Promiise<string>} box_name 箱体名称
* @param {Promiise<string>} box_xml 箱体xml描述信息
* @param {Promiise<function>} fn_callback 回调函数
* @param {Promiise<Number>} ui_sdk_type sdk执行类型 0:SAVE(保存到磁盘中) 1:DELETE(删除) 2:SET(保存) (空为添加)
* 返回：NA
* **/
function mc_sdk_set_box(box_name, box_xml, fn_callback, ui_sdk_type) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof box_name || 0 >= box_name.length) {
        fn_callback();
        return;
    }

    var ary_lang_file_opt = ["SAVE", "DELETE", "SET"];
    var str_file_opt = ary_lang_file_opt[ui_sdk_type] || "SET";

    if (
        "SET" === str_file_opt &&
        ("string" !== typeof box_xml || 0 >= box_xml.length)
    ) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("BOX_FILE");
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value(box_name, box_xml);
    obj_sdk_param.set_attr_val(box_name, "FILE_OPT", str_file_opt);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

/**
* set_mod_from_sdk
* @param {Promiise<Array>} ary_mod_data 模组数据数组
* @param {Promiise<function>} fn_callback 回调函数
* @param {Promiise<Number>} ui_sdk_type sdk执行类型 0:SAVE(保存到磁盘中) 1:DELETE(删除) 2:SET(保存) (空为添加)
* 返回：NA
* **/

function mc_sdk_set_mod(ary_mod_data, fn_callback, ui_sdk_type) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if (!Array.isArray(ary_mod_data) || 0 >= ary_mod_data.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var ary_lang_file_opt = ["SAVE", "DELETE", "SET"];
    var str_file_opt = ary_lang_file_opt[ui_sdk_type] || "SET";

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("MOD_FILE");
    obj_sdk_param.set_cmd("SET_PARAM");

    for (var idx = 0; idx < ary_mod_data.length; idx++) {
        var str_module_name = ary_mod_data[idx].name;
        var str_module_xml = ary_mod_data[idx].data;

        obj_sdk_param.set_param_value(str_module_name, str_module_xml);
        obj_sdk_param.set_attr_val(str_module_name, "FILE_OPT", str_file_opt);
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}


/**
* set_param_from_sdk
* @param {Promiise<string>} ui_json 页面识别的json字串
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_set_param(ui_json, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof ui_json || 0 >= ui_json.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var req_json = mc_sdk_param_json_ui_tans_item(ui_json);

    obj_req_sdk.push_req(req_json, fn_callback);
}

/**
 * param_ui_json trans param_item_json
 * @param {Promiise<string>} ui_json 页面识别的json字串
 * @returns {Promise<String>} 转换后的json字串
 */

function mc_sdk_param_json_ui_tans_item(ui_json) {
    if ("string" !== typeof ui_json || 0 >= ui_json.length) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_json(ui_json);
    obj_sdk_param.set_func("NORMAL");
    obj_sdk_param.set_cmd("SET_PARAM");
    return obj_sdk_param.get_json();
}

/**
 * set_reg_from_sdk
 * @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
 * @param {Promiise<string>} str_chip_name 显示芯片/行管芯片名称 (由b_chipname_type判断)
 * @param {Promiise<boolean>} b_chipname_type 传入芯片类型标识 true/false = 显示芯片名称/行管芯片名称
 * @param {Promiise<string>} item_json sdk识别的json字串
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_set_reg(str_ctrlchip_name, str_chip_name, b_chipname_type, item_json, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof item_json || 0 >= item_json.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fn_callback();
        return;
    }
    var str_req_fun = "SCANCHIP_REG_ITEM";

    if (b_chipname_type) {
        str_req_fun = "DISPCHIP_REG_ITEM";
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func(str_req_fun);
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value(str_chip_name, item_json);
    obj_sdk_param.set_attr_val(str_chip_name, "CTRLCHIP", str_ctrlchip_name);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

/**
 * set_reg_list_from_sdk
 * @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
 * @param {Promiise<string>} str_chip_name 显示芯片/行管芯片名称 (由b_chipname_type判断)
 * @param {Promiise<boolean>} b_chipname_type 传入芯片类型标识 true/false = 显示芯片名称/行管芯片名称
 * @param {Promiise<string>} item_json sdk识别的json字串
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_set_reg_list(str_ctrlchip_name, str_chip_name, b_chipname_type, item_json, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof item_json || 0 >= item_json.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fn_callback();
        return;
    }
    var str_req_fun = "SCANCHIP_REG_LIST";

    if (b_chipname_type) {
        str_req_fun = "DISPCHIP_REG_LIST";
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_func(str_req_fun);
    obj_sdk_param.set_param_value(str_chip_name, item_json);
    obj_sdk_param.set_attr_val(str_chip_name, "CTRLCHIP", str_ctrlchip_name);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
 *send_box_base  send_momery
 * @param {Promiise<string>} str_data_type 数据类型
 * @param {Promiise<string>} str_date 对应类型数据
 * @param {*} basic_date_val
 * @param {*} b_type
 * @param {*} str_cur_ctrl_card
 * @param {Promiise<Function>} fn_callback 回调函数
 * @param {Promiise<Object>} obj_transform_param 变换信息参数
 * @param {Promiise<string>} str_workmode 工作模式参数
 */
function mc_sdk_send_memory_box_base(str_data_type, str_date, basic_date_val, b_type, str_cur_ctrl_card, fn_callback, obj_transform_param, str_workmode) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof str_data_type || 0 >= str_data_type.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_date || 0 >= str_date.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof basic_date_val || 0 >= basic_date_val.length) {
        fn_callback();
        return;
    }
    var type = "";

    if (b_type) {
        type = "RAM";
    } else {
        type = "FLS";
    }

    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();
    var str_mirror = "0";
    var str_rotation = "(0:0:0)";
    var str_scale = "(0:0:1:1)";
    var str_size = false;

    if (obj_transform_param) {
        var s_mirror = obj_transform_param.str_mirror;
        var s_rotation = obj_transform_param.str_rotation;
        var s_scale = obj_transform_param.str_scale;
        var s_size = obj_transform_param.str_size;

        str_mirror = ("string" === typeof s_mirror && 0 !== s_mirror.length) ? s_mirror : str_mirror;
        str_rotation = ("string" === typeof s_rotation && 0 !== s_rotation.length) ? s_rotation : str_rotation;
        str_scale = ("string" === typeof s_scale && 0 !== s_scale.length) ? s_scale : str_scale;
        str_size = ("string" === typeof s_size && 0 !== s_size.length) ? s_size : str_size;
    }


    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("HW_BOX_BASE");
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value("RECVCARD", basic_date_val);
    obj_sdk_param.set_attr_val("RECVCARD", str_data_type, str_date);
    obj_sdk_param.set_attr_val("RECVCARD", "CHIPNAME", str_cur_ctrl_card);
    obj_sdk_param.set_attr_val("RECVCARD", "MEMTYPE", type);
    obj_sdk_param.set_attr_val("RECVCARD", "MIRROR", str_mirror);
    obj_sdk_param.set_attr_val("RECVCARD", "ROTATION", str_rotation);
    obj_sdk_param.set_attr_val("RECVCARD", "SCALE", str_scale);
    if (str_size) {
        obj_sdk_param.set_attr_val("RECVCARD", "SIZE", str_size);
        // var ary_size = str_size.split(":");

        // obj_sdk_param.set_attr_val("RECVCARD", "SIZE","(" + ary_size[2] + ":" + ary_size[3]);
    }
    if (str_workmode) {
        // obj_sdk_param.set_attr_val("RECVCARD", "WORKMODE", str_workmode);
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

// function mc_check_transform_param(obj_params){
//      var str_rotate = obj_params.rotation;

//     if (str_rotate && "string" === typeof str_rotate) {
//         var arr_rotate = str_rotate.split(",");

//         // 只有旋转角度情况
//         if (1 === arr_rotate.length) {
//             str_rotate = "0,0," + str_rotate;
//         }

//         if (3 !== str_rotate.split(",").length) {
//             return obj_params;
//         }
//     } else {
//         // 不存在情况
//         str_rotate = "0,0,0";
//     }

//     // 缩放
//     var str_scale = obj_params.scale;

//     if (str_scale && "string" === typeof str_scale) {
//         var arr_scale = str_scale.split(",");

//         // 无缩放基准点情况
//         if (2 === arr_scale.length) {
//             str_scale = "0,0," + arr_scale[0] + "," + arr_scale[1];
//         }

//         if (4 !== str_scale.split(",").length) {
//             return obj_params;
//         }
//     } else {
//         // 不存在情况
//         str_scale = "0,0,1,1";
//     }
// }

/**
 *send_presave
 * @param {*} basic_date_val
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_send_box_presave(basic_date_val, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof basic_date_val || 0 >= basic_date_val.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("RECVCARD_PRESAVE_DATA");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_param_value("0", basic_date_val);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

/**
 *get_box_base
 * @param {Promiise<string>} box_name 箱体名称
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_get_box_base(box_name, fn_callback, obj_transform_param) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof box_name || 0 >= box_name.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    var str_mirror = "0";
    var str_rotation = "(0:0:0)";
    var str_scale = "(0:0:1:1)";
    var str_size = false;
    var str_workmode = "0";

    if (obj_transform_param) {
        var s_mirror = obj_transform_param.str_mirror;
        var s_rotation = obj_transform_param.str_rotation;
        var s_scale = obj_transform_param.str_scale;
        var s_size = obj_transform_param.str_size;
        var s_workmode = obj_transform_param.str_workmode;

        str_mirror = ("string" === typeof s_mirror && 0 !== s_mirror.length) ? s_mirror : str_mirror;
        str_rotation = ("string" === typeof s_rotation && 0 !== s_rotation.length) ? s_rotation : str_rotation;
        str_scale = ("string" === typeof s_scale && 0 !== s_scale.length) ? s_scale : str_scale;
        str_size = ("string" === typeof s_size && 0 !== s_size.length) ? s_size : str_size;
        str_workmode = ("string" === typeof s_workmode && 0 !== s_workmode.length) ? s_workmode : str_workmode;
    }


    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("RECVCARD_BASE");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_param_value(box_name, "");
    obj_sdk_param.set_attr_val(box_name, "MIRROR", str_mirror);
    obj_sdk_param.set_attr_val(box_name, "ROTATION", str_rotation);
    obj_sdk_param.set_attr_val(box_name, "SCALE", str_scale);
    obj_sdk_param.set_attr_val(box_name, "WORKMODE", str_workmode);
    if (str_size) {
        obj_sdk_param.set_attr_val(box_name, "SIZE", str_size);
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

/**
 *send_box_perstore_msg
 * @param {Promiise<string>} box_name 箱体名称
 * @param {*} str_presave_data
 * @param {Promiise<Function>} fn_callback 回调函数
 * @param {Promiise<Function>} obj_transform_param 变换参数对象
 */

function mc_sdk_send_box_perstore(box_name, str_presave_data, fn_callback, obj_transform_param) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof box_name || 0 >= box_name.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_presave_data || 0 >= str_presave_data.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();
    var str_mirror = "0";
    var str_rotation = "(0:0:0)";
    var str_scale = "(0:0:1:1)";
    var str_size = false;
    var str_workmode = "0";

    if (obj_transform_param) {
        var s_mirror = obj_transform_param.str_mirror;
        var s_rotation = obj_transform_param.str_rotation;
        var s_scale = obj_transform_param.str_scale;
        var s_size = obj_transform_param.str_size;
        var s_workmode = obj_transform_param.str_workmode;

        str_mirror = ("string" === typeof s_mirror && 0 !== s_mirror.length) ? s_mirror : str_mirror;
        str_rotation = ("string" === typeof s_rotation && 0 !== s_rotation.length) ? s_rotation : str_rotation;
        str_scale = ("string" === typeof s_scale && 0 !== s_scale.length) ? s_scale : str_scale;
        str_size = ("string" === typeof s_size && 0 !== s_size.length) ? s_size : str_size;
        str_workmode = ("string" === typeof s_workmode && 0 !== s_workmode.length) ? s_workmode : str_workmode;
    }


    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("RECVCARD_PRESAVE_DATA");
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value(box_name, str_presave_data);
    obj_sdk_param.set_attr_val(box_name, "MIRROR", str_mirror);
    obj_sdk_param.set_attr_val(box_name, "ROTATION", str_rotation);
    obj_sdk_param.set_attr_val(box_name, "SCALE", str_scale);
    obj_sdk_param.set_attr_val(box_name, "WORKMODE", str_workmode);
    if (str_size) {
        obj_sdk_param.set_attr_val(box_name, "SIZE", str_size);
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}

/**
 *get_param
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_get_param(fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("NORMAL");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
 *get_dispchip_normal
 * @param {*} ary_req_data
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_get_dispchip_normal(ary_req_data, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("DISPCHIP_NORMAL");
    obj_sdk_param.set_cmd("GET_PARAM");
    for (var idx_req = 0; idx_req < ary_req_data.length; idx_req++) {
        var str_ctrlchip_name = ary_req_data[idx_req][0];
        var str_dispchip_name = ary_req_data[idx_req][1];

        obj_sdk_param.set_param_value(str_ctrlchip_name, str_dispchip_name);
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
 *get_dispchip_info_msg
 * @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
 * @param {Promiise<string>} str_dispchip_name 显示芯片名称
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_get_dicpchip_info_msg(str_ctrlchip_name, str_dispchip_name, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_dispchip_name || 0 >= str_dispchip_name.length) {
        fn_callback();
        return;
    }

    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("DISPCHIP_INFO");
    obj_sdk_param.set_param_value(str_dispchip_name, "");
    obj_sdk_param.set_attr_val(str_dispchip_name, "CTRLCHIP", str_ctrlchip_name);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
 *get_dispchip_access
 * @param {Promiise<string>} str_dispchip_name 显示芯片名称
 * @param {Promiise<string>} box_name 箱体名称
 * @param {Promiise<Function>} fn_callback 回调函数
 */

function mc_sdk_get_dispchip_access(str_dispchip_name, box_name, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("DISPCHIP_ACCESS");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_param_value(str_dispchip_name, "");
    if (0 < box_name.length) {
        obj_sdk_param.set_attr_val(str_dispchip_name, "BOX_FILE", box_name);
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
* get_reg
* @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
* @param {Promiise<string>} str_chip_name 显示芯片名称
* @param {Promiise<boolean>} b_chipname_type 传入芯片类型标识 true/false = 显示芯片名称/行管芯片名称
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_reg(str_ctrlchip_name, str_chip_name, b_chipname_type, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var str_req_fun = "DISPCHIP_REG_ITEM";

    if (!b_chipname_type) {
        str_req_fun = "SCANCHIP_REG_ITEM";
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func(str_req_fun);
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_param_value(str_chip_name, "");
    obj_sdk_param.set_attr_val(str_chip_name, "CTRLCHIP", str_ctrlchip_name);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
*get_reg_list
* @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
* @param {Promiise<string>} str_chip_name 显示芯片名称
* @param {Promiise<boolean>} b_chipname_type 传入芯片类型标识 true/false = 显示芯片名称/行管芯片名称
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_reg_list(str_ctrlchip_name, str_chip_name, b_chipname_type, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fn_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var str_req_fun = "SCANCHIP_REG_LIST";

    if (b_chipname_type) {
        str_req_fun = "DISPCHIP_REG_LIST";
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func(str_req_fun);
    obj_sdk_param.set_param_value(str_chip_name, "");
    obj_sdk_param.set_attr_val(str_chip_name, "CTRLCHIP", str_ctrlchip_name);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
*hw_hubcard_reg
* @param {Promiise<string>} str_place_type 设置发送/获取命令
* @param {Promiise<object>} obj_attr_val 属性数据
* @param {Promiise<boolean>} str_order_val 指令
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_hw_hubcard_reg(str_place_type, obj_attr_val, str_order_val, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("HW_HUBCARD_REG");
    obj_sdk_param.set_cmd(str_place_type);
    obj_sdk_param.set_param_value("CARD", str_order_val);
    for (var key in obj_attr_val) {
        if (Object.prototype.hasOwnProperty.call(obj_attr_val, key)) {
            obj_sdk_param.set_attr_val("CARD", key, obj_attr_val[key]);
        }
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}


/**
*hw_hubcard_reg
* @param {Promiise<boolean>} str_order_val 指令
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_hw_hubcard_save(str_order_val, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("HW_HUBCARD_SAVE");
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value("CARD", str_order_val);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
*hw_recaverd_get
* @param {Promiise<Array>} ary_recvcard_val 接收卡值
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_hw_get_revcard(ary_recvcard_val, fn_callback) {
    if (!Array.isArray(ary_recvcard_val) || 0 >= ary_recvcard_val.length) {
        fn_callback(0);
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("HW_RECVCARD_CONNECT");
    obj_sdk_param.set_cmd("GET_PARAM");

    for (var idx_recv = 0; idx_recv < ary_recvcard_val.length; idx_recv++) {
        obj_sdk_param.set_param_value(idx_recv.toString(), ary_recvcard_val[idx_recv]);
    }

    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
*get vers number
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_vers_number(fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("UPGRADE_CLOUD_EDITION");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/**
*get_ctrlchip_list
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_ctrlchip_list(fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();


    obj_sdk_param.set_func("CTRLCHIP_LIST");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
*get_hubchip_list
* @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_hubchip_list(str_ctrlchip_name, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("RECVHUB_LIST");
    obj_sdk_param.set_param_value("CTRLCHIP", str_ctrlchip_name);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
*get_recvcard_hub_file
* @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
* @param {Promiise<string>} str_hub_name hub卡名称
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_recvcard_hub_file(str_ctrlchip_name, str_hub_name, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if (
        "string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length ||
        "string" !== typeof str_hub_name || 0 >= str_hub_name.length
    ) {
        fn_callback("");
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("RECVCARD_HUB_FILE");
    obj_sdk_param.set_param_value(str_ctrlchip_name, str_hub_name);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
*get_dispchip_list
* @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_dispchip_list(str_ctrlchip_name, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("DISPCHIP_LIST");
    obj_sdk_param.set_param_value("CTRLCHIP", str_ctrlchip_name);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
*get_scanchip_list
* @param {Promiise<string>} str_ctrlchip_name 主控芯片名称
* @param {Promiise<function>} fn_callback 回调函数
* 返回：NA
* **/

function mc_sdk_get_scanchip_list(str_ctrlchip_name, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("SCANCHIP_LIST");
    obj_sdk_param.set_param_value("CTRLCHIP", str_ctrlchip_name);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
 *set_box_tplparam
 * @param {Promiise<Object>} obj_box_data 箱体数据
 * @param {Promise<String>} str_tpl_title 模板标题
 * @param {Promise<String>} str_tpl_descrit 模板描述
 * @param {Promiise<Function>} fn_callback 回调函数
 */
function mc_sdk_set_box_tplparam(obj_box_data, str_tpl_title, str_tpl_descrit, fn_callback) {
    var str_box_name = obj_box_data.name;
    var ary_box_gamma = obj_box_data.data.mc_util_get_gamma_val();

    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_func("BOX_TPLPARAM_DATA");
    obj_sdk_param.set_param_value(str_box_name, "");

    if (0 < ary_box_gamma.length) {
        obj_sdk_param.set_attr_val(str_box_name, "GAMA_R", ary_box_gamma[0].data);
        obj_sdk_param.set_attr_val(str_box_name, "GAMA_G", ary_box_gamma[0].data);
        obj_sdk_param.set_attr_val(str_box_name, "GAMA_B", ary_box_gamma[0].data);
    }
    obj_sdk_param.set_attr_val(str_box_name, "NAME", str_tpl_title);
    obj_sdk_param.set_attr_val(str_box_name, "DESCRIPT", str_tpl_descrit);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
 *get_box_tplparam_list
 * @param {Promiise<Object>} obj_box_data 箱体数据
 * @param {Promiise<Function>} fn_callback 回调函数
 */
function mc_sdk_get_box_tplparam_list(obj_box_data, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("BOX_TPLPARAM_LIST");
    obj_sdk_param.set_param_value(obj_box_data.str_disp_name, "");
    obj_sdk_param.set_attr_val(obj_box_data.str_disp_name, "CTRLCHIP", obj_box_data.str_ctrl_name);
    obj_sdk_param.set_attr_val(obj_box_data.str_disp_name, "SCANCHIP", obj_box_data.str_scan_name);
    obj_sdk_param.set_attr_val(obj_box_data.str_disp_name, "STR_CNT", obj_box_data.str_str_cnt);
    obj_sdk_param.set_attr_val(obj_box_data.str_disp_name, "SCLK_CNT", obj_box_data.str_sclk_cnt);
    obj_sdk_param.set_attr_val(obj_box_data.str_disp_name, "SCAN_CNT", obj_box_data.str_scan_cnt);
    obj_sdk_param.set_attr_val(obj_box_data.str_disp_name, "SCAN_LEN", obj_box_data.str_scan_len);

    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
 * get_box_tplparam
 * @param {Promise<String>} str_feature_key 匹配模板的key
 * @param {Promise<Function>} fn_callback 回调函数
 */
function mc_sdk_get_box_tplparam(str_feature_key, fn_callback) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_func("BOX_TPLPARAM_DATA");
    obj_sdk_param.set_param_value(str_feature_key, "");
    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
 * 直接硬件读写命令
 * @param {Number} ui_cmd_type 下发命令类型
 * @param {Number} ui_fun_type 下发命令
 * @param {String} str_card_val CARD属性值
 * @param {String} str_ars_val  ADDRESS属性值
 * @param {String} str_type_val TYPE属性值
 * @param {String} str_val VALUE属性值
 * @param {Function} fn_callback 请求成功回调函数
 */
function mc_sdk_hw_red_write(ui_cmd_type, ui_fun_type, str_card_val, str_ars_val, str_type_val, str_val, fn_callback) {
    var obj_cmd_lang = {
        0: "GET_PARAM",
        1: "SET_PARAM"
    };
    var obj_fun_lang = {
        // HW_OPT_W2：W2读写操作（并非所有硬件都支持）
        0: "HW_OPT_W2",
        // HW_OPT_SDRAM：SDRAM读写操作（并非所有硬件都支持）
        1: "HW_OPT_SDRAM",
        // HW_OPT_FLASH：FLASH读写操作（并非所有硬件都支持）
        2: "HW_OPT_FLASH",
        // HW_OPT_REGISTER：寄存器读写操作（并非所有硬件都支持）
        3: "HW_OPT_REGISTER"
    };
    var obj_sdk_param = new mc_sdk_param();
    var obj_req_sdk = new mc_sdk_req_mgr();

    obj_sdk_param.set_cmd(obj_cmd_lang[ui_cmd_type]);
    obj_sdk_param.set_func(obj_fun_lang[ui_fun_type]);
    obj_sdk_param.set_param_value("CARD", str_card_val);
    obj_sdk_param.set_attr_val("CARD", "ADDRESS", str_ars_val);
    obj_sdk_param.set_attr_val("CARD", "TYPE", str_type_val);
    obj_sdk_param.set_attr_val("CARD", "VALUE", str_val);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}


/**
 *  发送gama
 * @param {Number} ui_send_type 请求类型(0/1)(get/set)
 * @param {String} str_order 命令
 * @param {String} str_date gama数据
 * @param {String} str_ctrlchip_name 主控芯片名称
 * @param {String} str_memtype 发送类型
 * @param {Function} fn_callback 回调函数
 * @param {string} str_workmode 镜像/群发
 */
function mc_sdk_hw_box_gama(ui_send_type, str_order, str_date, str_ctrlchip_name, str_memtype, fn_callback, str_workmode) {
    if ("function" !== typeof fn_callback) {
        fn_callback("");
        return;
    }

    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd(ui_send_type ? "SET_PARAM" : "GET_PARAM");
    obj_sdk_param.set_func("HW_BOX_GAMA");

    obj_sdk_param.set_param_value("RECVCARD", str_order);
    obj_sdk_param.set_attr_val("RECVCARD", "CHIPNAME", str_ctrlchip_name);
    obj_sdk_param.set_attr_val("RECVCARD", "MEMTYPE", str_memtype);
    // obj_sdk_param.set_attr_val("RECVCARD", "WORKMODE", str_workmode);

    obj_sdk_param.set_attr_val("RECVCARD", "GAMA_R", str_date);
    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
 *
 * @param {Number} ui_send_type 请求类型(0/1)(get/set)
 * @param {String} str_order 命令
 * @param {String} str_mode 色域矫正开关
 * @param {Array} ary_gamut_list 色域列表
 * @param {String} str_ctrlchip_name 主控芯片名称
 * @param {String} str_memtype 发送类型
 * @param {Function} fn_callback 回调函数
 * @param {string} str_workmode 镜像/群发
 */
function mc_sdk_hw_box_gamut(ui_send_type, str_order, str_mode, ary_gamut_list, str_ctrlchip_name, str_memtype, fn_callback, str_workmode) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd(ui_send_type ? "SET_PARAM" : "GET_PARAM");
    obj_sdk_param.set_func("HW_BOX_GAMUT");
    obj_sdk_param.set_param_value("RECVCARD", str_order);
    var str_list = "";

    if (str_mode) {
        str_list = "(" + ary_gamut_list[0] + ":" + ary_gamut_list[4] + ":" +
            ary_gamut_list[7] + ":" + ary_gamut_list[1] + ":" + ary_gamut_list[3] + ":" + ary_gamut_list[8] +
            ":" + ary_gamut_list[2] + ":" + ary_gamut_list[5] + ":" + ary_gamut_list[6] + ")";

        obj_sdk_param.set_attr_val("RECVCARD", "MODE", "1");
        obj_sdk_param.set_attr_val("RECVCARD", "LIST", str_list);
    } else {
        obj_sdk_param.set_attr_val("RECVCARD", "MODE", "0");
    }

    obj_sdk_param.set_attr_val("RECVCARD", "CHIPNAME", str_ctrlchip_name);
    obj_sdk_param.set_attr_val("RECVCARD", "MEMTYPE", str_memtype);
    // obj_sdk_param.set_attr_val("RECVCARD", "WORKMODE", str_workmode);


    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}

/**
 *
 * @param {Number} ui_send_type 请求类型(0/1)(get/set)
 * @param {String} str_order 发送命令
 * @param {String} str_bright_data 亮度设置
 * @param {String} str_ctrlchip_name 主控芯片名称
 * @param {String} str_memtype 发送类型
 * @param {Function} fn_callback 回调函数
 * @param {string} str_workmode 镜像/群发
 */
function mc_send_box_bright_date(ui_send_type, str_order, str_bright_data, str_ctrlchip_name, str_memtype, fn_callback, str_workmode) {
    var obj_req_sdk = new mc_sdk_req_mgr();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("HW_BOX_BRIGHT");
    obj_sdk_param.set_cmd(ui_send_type ? "SET_PARAM" : "GET_PARAM");
    obj_sdk_param.set_param_value("RECVCARD", str_order);
    obj_sdk_param.set_attr_val("RECVCARD", "CMD", str_bright_data);
    if (str_ctrlchip_name) {
        obj_sdk_param.set_attr_val("RECVCARD", "CHIPNAME", str_ctrlchip_name);
    }
    obj_sdk_param.set_attr_val("RECVCARD", "MEMTYPE", str_memtype);
    // obj_sdk_param.set_attr_val("RECVCARD", "WORKMODE", str_workmode);


    obj_req_sdk.push_req(obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fn_callback("");
            return;
        }
        fn_callback(response);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取储存数组中对应名字的下标
 * 参数:
 *    @param {Promise<Array>} ary_data 储存数据的数组
 *    @param {Promise<Array>} name 查询下标的名字
 * 返回：
 *    @returns {Promise<Number>} 对应名字所在下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_data_get_idx_in_name(ary_data, name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    for (var idx = 0; idx < ary_data.length; idx++) {
        if (name === ary_data[idx].name) {
            return idx;
        }
    }
    return false;
}

/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    获取硬件连接状态
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.7.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_sdk_hardware_data() {
    // 硬件连接状态下 对应发送卡数据 格式1:[:发送卡[端口:[:HUB卡[:HUB端口[:接收卡]]]]]
    // 无HUB连接时 格式2：[：发送卡[：端口[：接收卡]]]
    var m_ary_sendcard_data = [];
    // 发送卡name [{id:"",name:"",card_type:"",mcu_ver:"",fpga_ver:""}] id唯一
    var m_ary_sendcard_name = [];


    // 硬件格式状态 ture:格式1 false:格式2
    // var m_b_hw_layout = false;

    // 请求状态
    var m_b_send_isok = false;


    // 回调函数
    var m_fn_callback = -1;
    var m_fn_hw_state_callback = -1;

    // 硬件连接状态字串
    var m_str_hardware = "";
    // 接收卡列表
    var m_arr_recvcard_list = [];

    // 第一张接收卡位置
    var m_str_fisrt_recvcard_idx = "";

    // 接收卡返回数据
    var m_str_recvcard_res = "";

    // 所有接收卡类型
    var m_str_recvcard_type = "";


    mc_creae_date();

    function mc_creae_date() {
        // 请求对象
        var obj_sdk_param = new mc_sdk_param();
        // 返回对象
        var obj_res_param = new mc_sdk_param();

        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_func("HW_SENDCARD_CONNECT");
        obj_sdk_param.set_cmd("GET_PARAM");
        mc_read_ajax_request(obj_sdk_param.get_json(), function (res_send) {
            // 处理发送卡数据
            obj_res_param.set_param_clear();
            obj_res_param.set_json(res_send);
            var ui_param_cnt = obj_res_param.get_param_cnt();
            var ui_send_i = 0;

            for (var idx_send_cnt = 0; idx_send_cnt < ui_param_cnt; idx_send_cnt++) {
                var str_send_idx = obj_res_param.get_param_name(idx_send_cnt);
                var ui_send_idx = Number(str_send_idx);

                if ("ERROR_CODE" === str_send_idx || isNaN(ui_send_idx)) {
                    continue;
                }
                var str_port_data = obj_res_param.get_param_value(str_send_idx);

                if (-1 !== str_port_data.indexOf(",")) {
                    str_port_data = str_port_data.split(",")[0];
                }
                if (!str_port_data || -1 === str_port_data.indexOf(":")) {
                    continue;
                }
                var ui_port_cnt = Number(str_port_data.split(":")[1]);

                m_ary_sendcard_data[ui_send_i] = [];
                for (var idx_add_port = 0; idx_add_port < ui_port_cnt; idx_add_port++) {
                    m_ary_sendcard_data[ui_send_idx].push([]);
                }
                ui_send_i++;
            }


            // deal
            var ui_len_send = m_ary_sendcard_data.length;

            if (0 >= ui_len_send) {
                m_b_send_isok = true;
                if ("function" === typeof m_fn_callback) {
                    m_fn_callback(0);
                }
                if ("function" === typeof m_fn_hw_state_callback) {
                    m_fn_hw_state_callback();
                }
                return;
            }

            // m_ary_sendcard_data 发送卡 len == 总数
            // 获取发送卡名称
            obj_sdk_param.set_param_clear();
            obj_sdk_param.set_func("HW_SENDCARD_NAME");
            obj_sdk_param.set_cmd("GET_PARAM");

            for (var index_cardname = 0; index_cardname < ui_len_send; index_cardname++) {
                obj_sdk_param.set_param_value(String(index_cardname), "");
            }

            mc_read_ajax_request(obj_sdk_param.get_json(), function (res_send_name) {
                // 处理sendname数据
                obj_res_param.set_param_clear();
                obj_res_param.set_json(res_send_name);
                ui_param_cnt = obj_res_param.get_param_cnt();

                for (var idx_cardname_idx = 0; idx_cardname_idx < ui_param_cnt; idx_cardname_idx++) {
                    var s_param_name = obj_res_param.get_param_name(idx_cardname_idx);

                    if ("ERROR_CODE" !== s_param_name) {
                        // sendcard name
                        m_ary_sendcard_name[idx_cardname_idx] = {
                            id: obj_res_param.get_attr_val(s_param_name, "ID"),
                            name: decodeURIComponent(obj_res_param.get_param_value(s_param_name).replaceAll("+", "%20")),
                            card_type: obj_res_param.get_attr_val(s_param_name, "CARD"),
                            mcu_ver: obj_res_param.get_attr_val(s_param_name, "MCU_VER"),
                            fpga_ver: obj_res_param.get_attr_val(s_param_name, "FPGA_VER")
                        };
                    }
                }

                // 根据发送卡,及port数据 获取hub数据
                obj_sdk_param.set_param_clear();
                obj_sdk_param.set_func("HW_HUBCARD_CONNECT");
                obj_sdk_param.set_cmd("GET_PARAM");

                var ui_send_port = 0;

                for (var idx_send = 0; idx_send < ui_len_send; idx_send++) {
                    ui_send_port = m_ary_sendcard_data[idx_send].length;
                    for (var idx_port = 0; idx_port < ui_send_port; idx_port++) {
                        var str_order_val = idx_send + ":" + idx_port;

                        obj_sdk_param.set_param_value(obj_sdk_param.get_param_cnt().toString(), str_order_val);
                    }
                }

                mc_read_ajax_request(obj_sdk_param.get_json(), function (res_hub) {
                    // 处理HUB数据
                    obj_res_param.set_param_clear();
                    obj_res_param.set_json(res_hub);
                    ui_param_cnt = obj_res_param.get_param_cnt();

                    for (var idx_hub_idx = 0; idx_hub_idx < ui_param_cnt; idx_hub_idx++) {
                        var str_param_name = obj_res_param.get_param_name(idx_hub_idx);

                        if ("ERROR_CODE" === str_param_name) {
                            continue;
                        }
                        var str_param_val = obj_res_param.get_param_value(str_param_name);
                        var ary_hub_site = mc_get_site_val(str_param_val);

                        if (!ary_hub_site || 2 !== ary_hub_site.length) {
                            continue;
                        }
                        var str_hub_port = obj_res_param.get_attr_val(str_param_name, "STATUS");

                        m_ary_sendcard_data[ary_hub_site[0]][ary_hub_site[1]] = mc_get_hub_port_cnt(str_hub_port);
                    }
                    // 根据发送卡,port,hub,hub_port获取对应的接收卡数据
                    obj_sdk_param.set_param_clear();
                    obj_sdk_param.set_func("HW_RECVCARD_CONNECT");
                    obj_sdk_param.set_cmd("GET_PARAM");
                    var str_order_value = "";

                    for (var idx_send_idx = 0; idx_send_idx < ui_len_send; idx_send_idx++) {
                        for (var idx_port_idx = 0; idx_port_idx < m_ary_sendcard_data[idx_send_idx].length; idx_port_idx++) {
                            for (var idx_hub = 0; idx_hub < m_ary_sendcard_data[idx_send_idx][idx_port_idx].length; idx_hub++) {
                                for (var idx_hub_port = 0; idx_hub_port < m_ary_sendcard_data[idx_send_idx][idx_port_idx][idx_hub].length; idx_hub_port++) {
                                    str_order_value = idx_send_idx + ":" + idx_port_idx + ":" + idx_hub + ":" + idx_hub_port;

                                    obj_sdk_param.set_param_value(obj_sdk_param.get_param_cnt().toString(), str_order_value);
                                }
                            }
                            if (!m_ary_sendcard_data[idx_send_idx][idx_port_idx].length) {
                                str_order_value = idx_send_idx + ":" + idx_port_idx + ":" + 0 + ":" + 0;

                                obj_sdk_param.set_param_value(obj_sdk_param.get_param_cnt().toString(), str_order_value);
                            }
                        }
                    }

                    mc_read_ajax_request(obj_sdk_param.get_json(), function (res_recvcard) {
                        m_str_recvcard_res = res_recvcard;
                        // 处理HUB数据
                        obj_res_param.set_param_clear();
                        obj_res_param.set_json(res_recvcard);

                        ui_param_cnt = obj_res_param.get_param_cnt();
                        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
                            var str_recv_name = obj_res_param.get_param_name(idx_param);

                            if ("ERROR_CODE" === str_recv_name) {
                                continue;
                            }
                            var str_rec_cnt = obj_res_param.get_attr_val(str_recv_name, "STATUS");


                            if (!str_rec_cnt || -1 === str_rec_cnt.indexOf(":")) {
                                continue;
                            }
                            var ary_recvcard = str_rec_cnt.split(":");

                            if (16 !== ary_recvcard.length) {
                                continue;
                            }
                            for (var idx_rec = 0; idx_rec < ary_recvcard.length - 1; idx_rec++) {
                                if (
                                    0 < Number(ary_recvcard[idx_rec])
                                ) {
                                    var str_recv_val = "CNT" + (idx_rec + 1);

                                    if (-1 === m_str_recvcard_type.indexOf(str_recv_val)) {
                                        m_str_recvcard_type += str_recv_val + ",";
                                    }
                                }
                            }
                            var ui_recvcard_cnt = Number(ary_recvcard[15]);
                            var str_recv_site = obj_res_param.get_param_value(str_recv_name);
                            var ary_site_val = mc_get_site_val(str_recv_site);

                            if (isNaN(ui_recvcard_cnt)) {
                                continue;
                            }
                            var ary_recvcard_cnt = [];

                            for (var idx_recvcard = 0; idx_recvcard < ui_recvcard_cnt; idx_recvcard++) {
                                ary_recvcard_cnt.push([]);
                            }
                            if (!m_ary_sendcard_data[ary_site_val[0]][ary_site_val[1]][ary_site_val[2]]) {
                                m_ary_sendcard_data[ary_site_val[0]][ary_site_val[1]] = ary_recvcard_cnt;
                                continue;
                            }
                            m_ary_sendcard_data[ary_site_val[0]][ary_site_val[1]][ary_site_val[2]][ary_site_val[3]] = ary_recvcard_cnt;
                        }
                        mc_get_hw_state_by_sdk();
                        m_b_send_isok = true;
                        if ("function" === typeof m_fn_callback) {
                            m_fn_callback(ui_len_send);
                        }
                        if ("function" === typeof m_fn_hw_state_callback) {
                            m_fn_hw_state_callback(m_str_hardware, m_ary_sendcard_name, m_arr_recvcard_list);
                        }
                    });
                });
            });
        });
    }

    // 解析地址字串,获取对应地址
    function mc_get_site_val(str_site_val) {
        if ("string" !== typeof str_site_val || 0 >= str_site_val.length) {
            return false;
        }

        if (-1 === str_site_val.indexOf(":")) {
            return false;
        }
        return str_site_val.split(":");
    }

    // 解析hub请求返回数据
    function mc_get_hub_port_cnt(str_hub_port_val) {
        if ("string" !== typeof str_hub_port_val || 0 >= str_hub_port_val.length || -1 === str_hub_port_val.indexOf(":")) {
            return [];
        }
        var ary_return = [];

        if (-1 === str_hub_port_val.indexOf(",")) {
            var ui_hub_cnt = Number(str_hub_port_val.split(":")[1]);

            ary_return.push([]);
            for (var idx_add_hub = 0; idx_add_hub < ui_hub_cnt; idx_add_hub++) {
                ary_return[0].push([]);
            }
            return ary_return;
        }
        var ary_port_cnt = str_hub_port_val.split(",");

        for (var idx_port = 0; idx_port < ary_port_cnt.length; idx_port++) {
            ary_return.push([]);
            var ui_hub_cnt_a = Number(ary_port_cnt[idx_port].split(":")[1]);

            for (var idx_hub = 0; idx_hub < ui_hub_cnt_a; idx_hub++) {
                ary_return[idx_port].push([]);
            }
        }
        return ary_return;
    }
    // 解析硬件连接状态 获取硬件连接状态字串
    function mc_get_hw_state_by_sdk() {
        var str_return = "";


        for (var idx_send = 0; idx_send < m_ary_sendcard_data.length; idx_send++) {
            str_return += "[";
            var ui_port_cnt = m_ary_sendcard_data[idx_send].length;
            var str_recv_name = "";

            if (0 === ui_port_cnt) {
                str_return += "0,";
                str_recv_name += "0,";
            }

            for (var idx_port = 0; idx_port < ui_port_cnt; idx_port++) {
                var ui_hub_port_cnt = m_ary_sendcard_data[idx_send][idx_port].length;
                var str_hub_recv_val = "";

                if (0 === ui_hub_port_cnt) {
                    str_return += "0,";
                    str_recv_name += "0,";
                    continue;
                } else {
                    for (var idx_hub_port = 0; idx_hub_port < ui_hub_port_cnt; idx_hub_port++) {
                        var ui_recvcard_cnt = 0;

                        var ui_hub_port_card_cnt = m_ary_sendcard_data[idx_send][idx_port][idx_hub_port].length;

                        if (!ui_hub_port_card_cnt) {
                            continue;
                        }
                        str_hub_recv_val += "(" + ui_hub_port_card_cnt + "|";
                        for (var idx_rec = 0; idx_rec < ui_hub_port_card_cnt; idx_rec++) {
                            var ui_hub_port_rec_cnt = m_ary_sendcard_data[idx_send][idx_port][idx_hub_port][idx_rec].length;

                            if (ui_hub_port_rec_cnt && !m_str_fisrt_recvcard_idx) {
                                m_str_fisrt_recvcard_idx = idx_send + ":" + idx_port + ":" + idx_hub_port + ":" + idx_rec;
                            }
                            ui_recvcard_cnt += ui_hub_port_rec_cnt;
                        }
                        str_hub_recv_val += ui_recvcard_cnt + "):";
                    }
                }
                if (str_hub_recv_val) {
                    str_return += str_hub_recv_val.substring(0, str_hub_recv_val.length - 1) + ",";
                    str_recv_name += str_hub_recv_val.substring(0, str_hub_recv_val.length - 1) + ",";
                    continue;
                }
                str_return += ui_hub_port_cnt + ",";
                str_recv_name += ui_hub_port_cnt + ",";
                if (ui_hub_port_cnt && !m_str_fisrt_recvcard_idx) {
                    m_str_fisrt_recvcard_idx = idx_send + ":" + idx_port;
                }
            }

            str_return = str_return.slice(0, -1);
            str_recv_name = str_recv_name.slice(0, -1);
            m_arr_recvcard_list.push(str_recv_name);
            str_return += "],";
        }
        m_str_hardware = str_return.slice(0, -1);
    }

    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    读取硬件数据
* 参数:
*    @param {Promise<str_data_json>} str_data_json 请求内容
*    @param {Promise<function>} fun_callback 回调函数
* 备注:
*   此ajax请求方式设置自动清除内存,所有请求均为一次性数据.
* 返回：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.7.13
*      内容 : 所有代码
************************************************************************************************/
    function mc_read_ajax_request(str_data_json, fun_callback) {
        $.ajax({
            type: "POST",
            url: "/access_shell",
            data: str_data_json,
            headers: {
                "Cache-Control": "must-revalidate, post-check=0, pre-check=0"
            },
            success: function (response, status) {
                if ("success" !== status) {
                    return;
                }
                fun_callback(response);
            }
        });
    }

    /* ************************************** API ***************************************** */
    /**
* @param {Function} fn_callback 回调函数返回对应数值
*/
    // 获取发送卡数量
    this.get_sendscard_cnt = function (fn_callback) {
        if (m_b_send_isok) {
            fn_callback(m_ary_sendcard_data.length);
            return;
        }
        m_fn_callback = fn_callback;
    };
    // 获取对应发送卡端口数量
    this.get_port_cnt = function (ui_send_idx) {
        if (m_b_send_isok) {
            try {
                return m_ary_sendcard_data[ui_send_idx].length;
            } catch (err) {
                return 0;
            }
        }
        return 0;
    };
    // 获取对应发送卡下对应端口下hub数量
    this.get_hub_cnt = function (ui_send_idx, ui_port_idx) {
        if (m_b_send_isok) {
            try {
                if (m_ary_sendcard_data[ui_send_idx][ui_port_idx][0].length) {
                    return m_ary_sendcard_data[ui_send_idx][ui_port_idx].length;
                }
            } catch (err) {
                return 0;
            }
        }
        return 0;
    };
    // 获取对应发送卡下对应端口下hub数量
    this.get_hub_prot_cnt = function (ui_send_idx, ui_port_idx, ui_hub_idx) {
        if (m_b_send_isok) {
            try {
                if (m_ary_sendcard_data[ui_send_idx][ui_port_idx][0].length) {
                    return m_ary_sendcard_data[ui_send_idx][ui_port_idx][ui_hub_idx].length;
                }
            } catch (err) {
                return 0;
            }
        }
        return 0;
    };
    // 获取对应发送卡下对应端口下对应hub下接收卡数量
    this.get_recvcard_cnt = function (ui_send_idx, ui_port_idx, ui_hub_idx, ui_hub_prot_idx) {
        if (m_b_send_isok) {
            try {
                return m_ary_sendcard_data[ui_send_idx][ui_port_idx][ui_hub_idx][ui_hub_prot_idx].length;
            } catch (err) {
                if (!m_ary_sendcard_data[ui_send_idx] || !m_ary_sendcard_data[ui_send_idx][ui_port_idx]) {
                    return 0;
                }
                return m_ary_sendcard_data[ui_send_idx][ui_port_idx].length;
            }
        }
        return 0;
    };
    // 获取硬件连接状态字串
    this.get_hw_state = function (fn_callback) {
        if (m_b_send_isok) {
            fn_callback(m_str_hardware, m_ary_sendcard_name, m_arr_recvcard_list);
        }
        m_fn_hw_state_callback = fn_callback;
    };
    // 获取第一张接收卡位置
    this.get_fist_recvcard_idx = function () {
        if (m_str_fisrt_recvcard_idx) {
            return m_str_fisrt_recvcard_idx.split(":");
        }
        return ["0", "0"];
    };
    // 获取指定卡下接收卡类型
    this.get_recvcard_type = function (ui_send_idx, ui_port_idx, ui_hub_idx, ui_hub_prot_idx) {
        if (m_b_send_isok) {
            var obj_recvcard_type = new mc_sdk_param();

            obj_recvcard_type.set_json(m_str_recvcard_res);
            var ui_param_cnt = obj_recvcard_type.get_param_cnt();
            var str_order_val = ui_send_idx + ":" + ui_port_idx + ":";

            if (ui_hub_idx) {
                str_order_val += ui_hub_idx + ":" + ui_hub_prot_idx;
            } else {
                str_order_val += "0:0";
            }
            var str_recvcard_type = "";

            for (var idx = 0; idx < ui_param_cnt; idx++) {
                var str_param_name = obj_recvcard_type.get_param_name(idx);
                var str_param_val = obj_recvcard_type.get_param_value(str_param_name);

                if (str_order_val === str_param_val) {
                    str_recvcard_type = obj_recvcard_type.get_attr_val(str_param_name, "STATUS");
                    break;
                }
            }


            if (str_recvcard_type && -1 !== str_recvcard_type.indexOf(":")) {
                var ary_recvcard_type = str_recvcard_type.split(":");

                str_recvcard_type = "";
                for (var idx_type = 0; idx_type < ary_recvcard_type.length; idx_type++) {
                    var ui_recvcard_cnt = Number(ary_recvcard_type[idx_type]);

                    if (isNaN(ui_recvcard_cnt) || 0 >= ui_recvcard_cnt || 15 === idx_type) {
                        continue;
                    }
                    str_recvcard_type += "CNT" + (idx_type + 1) + ",";
                }
                str_recvcard_type = str_recvcard_type.slice(0, -1);
                return str_recvcard_type;
            }
        }
        return "";
    };
    // 获取当前所有卡下所有接收卡类型
    this.get_recvcard_type_all = function () {
        return m_str_recvcard_type;
    };
    // 重新获取硬件连接黄台
    this.update_hw_state = function () {
        m_ary_sendcard_data = [];
        m_ary_sendcard_data.length = 0;
        m_b_send_isok = false;
        m_fn_callback = -1;
        m_fn_hw_state_callback = -1;
        m_str_hardware = "";
        m_str_fisrt_recvcard_idx = "";
        m_str_recvcard_res = "";
        m_str_recvcard_type = "";
        m_ary_sendcard_name = [];
        m_ary_sendcard_name.length = 0;
        m_arr_recvcard_list = [];
        m_arr_recvcard_list.length = 0;

        mc_creae_date();
    };
}
